/*
 * @file oledc_fontLargeSans.h
 *
 * @author Matthew Matz
 *
 * @version 0.9
 *
 * @copyright Copyright (C) Parallax, Inc. 2016.  See end of file for
 * terms of use (MIT License).
 *
 * @brief 0.96-inch RGB OLED font source, see oledc_.h for documentation.
 *
 * @detail Please submit bug reports, suggestions, and improvements to
 * this code to editor@parallax.com.
 */

char font_lg_index[] = {   // character index of the bitfield - must be summed
0x01, 0x0D, 0x10, 0x23, 0x29, 0x29, 0x2C, 0x08, 0x15, 0x15, 0x1C, 0x12, 0x0E, 0x09, 0x06, 0x12, 0x2A, 0x1C, 0x21, 0x23, 0x26, 0x23, 0x27, 0x1C, 0x2A, 
0x27, 0x0A, 0x13, 0x17, 0x18, 0x17, 0x17, 0x2D, 0x23, 0x26, 0x1E, 0x23, 0x21, 0x1A, 0x28, 0x1E, 0x1C, 0x1A, 0x20, 0x13, 0x1B, 0x24, 0x23, 0x1E, 0x29, 
0x22, 0x26, 0x16, 0x1E, 0x1D, 0x1D, 0x26, 0x1A, 0x22, 0x14, 0x12, 0x14, 0x13, 0x10, 0x08, 0x19, 0x1E, 0x18, 0x1E, 0x1B, 0x1B, 0x26, 0x19, 0x19, 0x21, 
0x1D, 0x18, 0x1C, 0x15, 0x1C, 0x25, 0x24, 0x11, 0x17, 0x1A, 0x15, 0x15, 0x19, 0x1C, 0x20, 0x18, 0x18, 0x0C, 0x18, 
};

char font_lg_zeroMap[] = {   // 7 byte wide map of zero bytes in the font
0x00, 0x00, 0x27, 0xFF, 0x80, 0x00, 0x00, 
0x00, 0x36, 0xD8, 0x0D, 0xB6, 0x00, 0x00, 
0x1B, 0x6D, 0xFF, 0xDB, 0x7F, 0xF2, 0x00, 
0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 
0xFF, 0xFF, 0xDA, 0xDF, 0xFF, 0xF8, 0x00, 
0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB4, 0x80, 
0x00, 0x00, 0x1B, 0x6C, 0x00, 0x00, 0x00, 
0x00, 0x0D, 0xFF, 0xF6, 0xD2, 0x00, 0x00, 
0x00, 0x1B, 0x6F, 0xFF, 0xE0, 0x00, 0x00, 
0x01, 0xB6, 0xDB, 0x6D, 0xB6, 0xDB, 0x00, 
0x09, 0x24, 0xB6, 0xD9, 0x24, 0x90, 0x00, 
0x00, 0x49, 0xB6, 0xDB, 0x00, 0x00, 0x00, 
0x00, 0x04, 0x92, 0x49, 0x24, 0x00, 0x00, 
0x00, 0x01, 0x24, 0x92, 0x00, 0x00, 0x00, 
0x02, 0x49, 0xB6, 0x4D, 0xB2, 0x40, 0x00, 
0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x00, 
0x07, 0xDB, 0x6F, 0xFF, 0xC9, 0x20, 0x00, 
0x02, 0xDB, 0x7F, 0xFF, 0xFF, 0xE0, 0x00, 
0x02, 0x5F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 
0x1B, 0x6D, 0xBF, 0xFF, 0xFF, 0xF6, 0x00, 
0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 
0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00, 
0x00, 0xDB, 0x7F, 0xFD, 0xB6, 0xC8, 0x00, 
0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 
0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0, 0x00, 
0x00, 0x01, 0xB6, 0xD8, 0x00, 0x00, 0x00, 
0x00, 0x09, 0x3F, 0xFF, 0xE0, 0x00, 0x00, 
0x01, 0x2D, 0xB6, 0xDF, 0xFC, 0x00, 0x00, 
0x03, 0x6D, 0xB6, 0xDB, 0x6D, 0x80, 0x00, 
0x00, 0x6F, 0xFE, 0xDB, 0x64, 0x80, 0x00, 
0x00, 0x03, 0x7F, 0xFD, 0xB6, 0xC0, 0x00, 
0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDB, 0x00, 
0x9B, 0x6F, 0xFF, 0xFF, 0xED, 0xA0, 0x00, 
0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 
0x1B, 0xFF, 0xED, 0xB6, 0xDB, 0x40, 0x00, 
0x1F, 0xFF, 0x6D, 0xB7, 0xFF, 0xD0, 0x00, 
0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 
0x00, 0x7F, 0xFB, 0x6D, 0xB6, 0xC0, 0x00, 
0x0B, 0xFF, 0xED, 0xBF, 0xFF, 0xFF, 0x00, 
0x1F, 0xFE, 0x92, 0x49, 0x7F, 0xF8, 0x00, 
0x02, 0xDB, 0x7F, 0xFE, 0xDB, 0x40, 0x00, 
0x02, 0xDB, 0x6D, 0xBF, 0xFE, 0x00, 0x00, 
0x03, 0xFF, 0xD2, 0xFF, 0xFB, 0x68, 0x00, 
0x00, 0x7F, 0xFC, 0x92, 0x49, 0x00, 0x00, 
0x1F, 0x96, 0xD2, 0x4D, 0xFF, 0xC0, 0x00, 
0x1F, 0xFE, 0xDB, 0xDB, 0x7F, 0xF8, 0x00, 
0x1B, 0xFF, 0x6D, 0xB6, 0xDF, 0xFA, 0x00, 
0x03, 0xFF, 0xDB, 0x6D, 0xB6, 0xD8, 0x00, 
0x0D, 0xFF, 0xFD, 0xB7, 0xFF, 0xFF, 0x80, 
0x03, 0xFF, 0xDB, 0x7F, 0xFF, 0xE0, 0x00, 
0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 
0x04, 0x92, 0x7F, 0xFC, 0x92, 0x48, 0x00, 
0x1F, 0xFF, 0x24, 0x92, 0x7F, 0xF8, 0x00, 
0x05, 0xBF, 0xF6, 0x9B, 0x66, 0xD9, 0x00, 
0x0F, 0xF9, 0xB2, 0xDB, 0x4F, 0xD8, 0x00, 
0xB6, 0xFF, 0xFB, 0xFF, 0xFB, 0x68, 0x00, 
0x24, 0xB6, 0xF6, 0xD9, 0xB6, 0x49, 0x00, 
0x16, 0xDF, 0xFF, 0xFF, 0xFB, 0x40, 0x00, 
0x00, 0x0F, 0xFF, 0xB6, 0xD0, 0x00, 0x00, 
0x00, 0x92, 0xDB, 0xDB, 0x49, 0x00, 0x00, 
0x00, 0x0B, 0x6D, 0xFF, 0xF0, 0x00, 0x00, 
0x09, 0x36, 0xC9, 0x2D, 0xB4, 0x80, 0x00, 
0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x00, 
0x00, 0x92, 0x49, 0x24, 0x00, 0x00, 0x00, 
0x02, 0x6D, 0xB6, 0xDB, 0x6D, 0xB0, 0x00, 
0x03, 0xFF, 0xF6, 0xDB, 0x6D, 0xB0, 0x00, 
0x03, 0x6D, 0xB6, 0xDB, 0x6D, 0x80, 0x00, 
0x1B, 0x6D, 0xB6, 0xDB, 0xFF, 0xC0, 0x00, 
0x1B, 0x6D, 0xB6, 0xDB, 0x6D, 0x90, 0x00, 
0x09, 0x25, 0xFF, 0xED, 0xB6, 0xC8, 0x00, 
0x13, 0xFF, 0xFF, 0xFF, 0xFF, 0x68, 0x00, 
0x03, 0xFF, 0xD2, 0x49, 0x6D, 0xB0, 0x00, 
0x02, 0x6D, 0xBF, 0xFF, 0xC9, 0x00, 0x00, 
0x03, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 
0x03, 0xFF, 0xD6, 0xDB, 0x6D, 0xB0, 0x00, 
0x00, 0x5B, 0x6F, 0xFF, 0xC9, 0x20, 0x00, 
0x1B, 0x6C, 0x96, 0xDB, 0x25, 0xB6, 0xC0, 
0x03, 0x6D, 0x92, 0x49, 0x6D, 0xB0, 0x00, 
0x1B, 0x6D, 0xB6, 0xDB, 0x6D, 0xB0, 0x00, 
0x03, 0xFF, 0xFF, 0xFF, 0xFE, 0xD8, 0x00, 
0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 
0x00, 0x6D, 0xB2, 0x49, 0x24, 0x92, 0x00, 
0x03, 0x6D, 0xB6, 0xDB, 0x6D, 0x00, 0x00, 
0x09, 0x25, 0xFF, 0xFB, 0x6D, 0x80, 0x00, 
0x03, 0x6D, 0xA4, 0x92, 0x6D, 0xB0, 0x00, 
0x09, 0x2D, 0xB4, 0x93, 0x6C, 0x92, 0x00, 
0x5B, 0x69, 0xB2, 0xDA, 0x6D, 0x90, 0x00, 
0x1B, 0x6D, 0xB6, 0xDB, 0x6D, 0xB0, 0x00, 
0x17, 0xFF, 0xF6, 0xDB, 0x36, 0xC9, 0x00, 
0x03, 0x6D, 0xB6, 0xDB, 0x6D, 0x80, 0x00, 
0x09, 0x25, 0xFF, 0xF6, 0xDA, 0x00, 0x00, 
0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, 
0x00, 0x5B, 0x6F, 0xFF, 0xA4, 0x90, 0x00, 
0x09, 0x24, 0x92, 0x49, 0x24, 0x90, 0x00, 
};

char oled_font_lg[] = {   // bit field of the font with zero bytes removed
0x18, 0x3C, 0xFF, 0xFC, 0x3C, 0xFF, 0xFC, 0x3C, 0xFF, 0xFC, 0x18, 0xFF, 0xFC, 0x01, 0xFC, 0x01, 0xFC, 0x01, 0xFC, 0x01, 0xFC, 0x01, 0xFC, 0x01, 0xFC, 0x01, 0xFC, 0x01, 0xFC, 0x01, 0xC0, 0x01, 0xC7, 0x3F, 0xC7, 0x3F, 0xFF, 0x3F, 0xFF, 0xF8, 0x01, 0xFF, 0xF8, 0x01, 0xC7, 0xF8, 0x01, 0xC7, 0x3F, 0xC7, 0x3F, 0xFF, 0x3F, 0xFF, 0xF8, 0x01, 0xFF, 0xF8, 0x01, 0xC7, 0xF8, 0x01, 0xC7, 0x07, 0x1C, 0x03, 0xC0, 0x3C, 0x0F, 0xE0, 0x38, 0x0F, 
0xF0, 0xB8, 0x1F, 0xF0, 0xFC, 0x1E, 0x78, 0xFF, 0xFC, 0x38, 0x3F, 0xFF, 0xF8, 0x38, 0x7F, 0xFE, 0x38, 0x79, 0xFE, 0x1C, 0x78, 0x3E, 0x1F, 0xF0, 0x38, 0x1F, 0xF0, 0x70, 0x0F, 0xE0, 0x70, 0x03, 0xC0, 0x20, 0x01, 0xF0, 0x30, 0x03, 0xF8, 0x3C, 0x06, 0x0C, 0x1E, 0x06, 0x0C, 0x07, 0x86, 0x0C, 0x03, 0xC3, 0xF8, 0xF1, 0xF0, 0x7C, 0x0F, 0x9E, 0x1F, 0xCF, 0x80, 0x30, 0x63, 0xC0, 0x30, 0x61, 0xF0, 0x30, 0x60, 0x78, 0x1F, 0xC0, 0x3C, 0x0F, 
0x80, 0x0C, 0x07, 0xC0, 0x0F, 0xE1, 0xE0, 0x1F, 0xF3, 0xF0, 0x1F, 0xFF, 0xF8, 0x3C, 0x3F, 0xFC, 0x38, 0x3F, 0x3C, 0x38, 0x7C, 0x1C, 0x38, 0xFE, 0x1C, 0x39, 0xF7, 0x3C, 0x3B, 0xE7, 0xFC, 0x1F, 0xC3, 0xF8, 0x1F, 0xF3, 0xF8, 0x1F, 0xF0, 0xF0, 0x3F, 0xF0, 0x38, 0xF0, 0x30, 0x20, 0x01, 0xFC, 0x01, 0xFC, 0x01, 0xFC, 0x01, 0xFC, 0x03, 0xFC, 0x0F, 0xFF, 0x80, 0x3F, 0xFF, 0xE0, 0xFF, 0xFF, 0xF0, 0xFE, 0x01, 0xFC, 0xF0, 0x7E, 0xC0, 0x1F, 
0x80, 0x0E, 0x02, 0x04, 0x80, 0x0E, 0xC0, 0x1F, 0xF0, 0x7E, 0xFC, 0x03, 0xFC, 0x7F, 0xFF, 0xF8, 0x3F, 0xFF, 0xE0, 0x0F, 0xFF, 0x80, 0x01, 0xFE, 0x02, 0x40, 0x0E, 0x70, 0x06, 0x60, 0x07, 0xE0, 0x03, 0xC0, 0x3F, 0xFC, 0x3F, 0xFC, 0x3F, 0xFC, 0x3F, 0xFC, 0x03, 0xC0, 0x07, 0xE0, 0x06, 0x60, 0x0E, 0x70, 0x02, 0x40, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x70, 0x70, 
0x70, 0xC0, 0x79, 0xE0, 0x3F, 0xE0, 0x3F, 0xE0, 0x1F, 0xC0, 0x07, 0x80, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x1E, 0x3F, 0x3F, 0x3F, 0x3F, 0x1E, 0xC0, 0xF8, 0xFE, 0x3F, 0x80, 0x0F, 0xF0, 0x03, 0xFC, 0x7F, 0x1F, 0xE0, 0x07, 0xF8, 0x01, 0xFC, 0x3C, 0x0C, 0x01, 0xFE, 0x07, 0xFF, 0xC0, 0x0F, 0xFF, 0xE0, 0x1F, 0xFF, 0xF0, 0x3F, 0xC1, 0xF0, 0x3C, 0xE0, 0x78, 0x38, 0x70, 0x38, 0x38, 0x78, 0x38, 0x38, 0x38, 0x38, 0x3C, 
0x1C, 0x78, 0x1F, 0x0F, 0xF8, 0x1F, 0xFF, 0xF0, 0x0F, 0xFF, 0xE0, 0x07, 0xFF, 0xC0, 0xFF, 0x40, 0x38, 0x01, 0xE0, 0x38, 0xE0, 0x38, 0xF0, 0x38, 0x70, 0x38, 0x70, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x20, 0x3C, 0xF0, 0x3E, 0x70, 0x3F, 0x78, 0x3F, 0x80, 0x38, 0x3B, 0xC0, 0x38, 0x39, 0xE0, 0x38, 0x38, 0xF8, 0x78, 0x38, 0x7F, 0xF8, 0x38, 0x3F, 0xF0, 0x38, 0x1F, 0xE0, 
0x38, 0x07, 0xC0, 0x38, 0x1C, 0x38, 0x70, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x7C, 0x78, 0x1C, 0x7F, 0xF8, 0x1F, 0xFF, 0xF0, 0x1F, 0xE7, 0xF0, 0x0F, 0xE3, 0xC0, 0x07, 0xC0, 0x03, 0xC0, 0x03, 0xE0, 0x03, 0xF8, 0x03, 0xFC, 0x03, 0x9F, 0x03, 0x8F, 0xC0, 0x03, 0x83, 0xE0, 0x03, 0x81, 0xF8, 0x03, 0x80, 0x78, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 
0xF8, 0x03, 0x80, 0x03, 0x80, 0x38, 0x1F, 0xF8, 0x38, 0x1F, 0xF8, 0x38, 0x1F, 0xF8, 0x38, 0x1F, 0xF8, 0x38, 0x1C, 0x38, 0x38, 0x1C, 0x38, 0x3C, 0x1C, 0x38, 0x1C, 0x3C, 0x38, 0x1F, 0xFC, 0x38, 0x0F, 0xF8, 0x38, 0x0F, 0xF0, 0x38, 0x03, 0xE0, 0x03, 0xFE, 0x0F, 0xFF, 0x80, 0x1F, 0xFF, 0xE0, 0x1F, 0xFF, 0xE0, 0x3E, 0x39, 0xF0, 0x38, 0x1C, 0x70, 0x38, 0x1C, 0x78, 0x38, 0x1C, 0x38, 0x38, 0x1C, 0x38, 0x3C, 0x3C, 0x38, 0x1F, 0xFC, 0x38, 
0x1F, 0xF8, 0x38, 0x0F, 0xF0, 0x03, 0xE0, 0x38, 0x20, 0x38, 0x38, 0x38, 0x3E, 0x38, 0x3F, 0x80, 0x38, 0x1F, 0xE0, 0x38, 0x07, 0xF8, 0x38, 0x01, 0xFE, 0x38, 0x7F, 0xB8, 0x1F, 0xF8, 0x07, 0xF8, 0x01, 0xF8, 0x78, 0x07, 0x83, 0xC0, 0x1F, 0xC7, 0xE0, 0x1F, 0xEF, 0xF0, 0x3F, 0xFF, 0xF0, 0x3C, 0x7E, 0x78, 0x38, 0x3C, 0x38, 0x38, 0x3C, 0x38, 0x38, 0x38, 0x38, 0x38, 0x7C, 0x38, 0x3C, 0xFE, 0x78, 0x1F, 0xFF, 0xF8, 0x1F, 0xE7, 0xF0, 0x0F, 
0xE7, 0xF0, 0x07, 0x81, 0xE0, 0x0F, 0x80, 0x38, 0x1F, 0xE0, 0x38, 0x3F, 0xF0, 0x38, 0x7F, 0xF0, 0x38, 0x78, 0x78, 0x38, 0x70, 0x38, 0x38, 0x70, 0x38, 0x3C, 0x70, 0x38, 0x1C, 0x70, 0x38, 0x1F, 0x38, 0xF8, 0x0F, 0xFF, 0xF0, 0x07, 0xFF, 0xF0, 0x03, 0xFF, 0xE0, 0xFF, 0x1C, 0x0E, 0x3E, 0x1F, 0x3E, 0x1F, 0x3E, 0x1F, 0x1C, 0x0E, 0x70, 0x70, 0x70, 0xC0, 0xE0, 0x79, 0xE1, 0xF0, 0x3F, 0xE1, 0xF0, 0x3F, 0xE1, 0xF0, 0x1F, 0xC0, 0xE0, 0x07, 
0x80, 0x60, 0xF0, 0x01, 0xF8, 0x03, 0xFC, 0x07, 0xFE, 0x07, 0x9E, 0x0F, 0x0F, 0x1E, 0x07, 0x80, 0x3C, 0x03, 0xC0, 0x18, 0x01, 0x80, 0x08, 0x01, 0x01, 0xC7, 0x01, 0xC7, 0x01, 0xC7, 0x01, 0xC7, 0x01, 0xC7, 0x01, 0xC7, 0x01, 0xC7, 0x01, 0xC7, 0x01, 0xC7, 0x01, 0xC7, 0x01, 0xC7, 0x01, 0xC7, 0x08, 0x01, 0x18, 0x01, 0x80, 0x3C, 0x03, 0xC0, 0x1E, 0x07, 0x80, 0x0F, 0x0F, 0x07, 0x9E, 0x07, 0xFE, 0x03, 0xFC, 0x01, 0xF8, 0xF0, 0x60, 0x1C, 
0x18, 0x1C, 0x3C, 0xF8, 0x1C, 0x3C, 0xF8, 0x1C, 0x3C, 0xF8, 0x3C, 0x18, 0xFC, 0x78, 0x3F, 0xF8, 0x1F, 0xF0, 0x1F, 0xE0, 0x07, 0xC0, 0x07, 0xFE, 0x3F, 0xFF, 0xC0, 0x7F, 0xFF, 0xF0, 0xFC, 0x01, 0xFC, 0xF1, 0xFE, 0x3E, 0xE3, 0xFF, 0x8F, 0xC3, 0xFF, 0xC7, 0xC3, 0x83, 0xC3, 0xC1, 0xF1, 0xC3, 0xC1, 0xFF, 0xC3, 0xC3, 0xFF, 0xC3, 0xE3, 0x83, 0xC7, 0x03, 0xC0, 0x1F, 0x01, 0xFF, 0xFE, 0xFF, 0xFC, 0x3F, 0xF0, 0x38, 0x3F, 0x80, 0x3F, 0xF0, 
0x0F, 0xFE, 0x03, 0xFF, 0xE0, 0x03, 0x9F, 0xF8, 0x03, 0x81, 0xF8, 0x03, 0x80, 0x38, 0x03, 0x83, 0xF8, 0x03, 0xBF, 0xF8, 0x03, 0xFF, 0xF0, 0x1F, 0xFF, 0x3F, 0xF8, 0x3F, 0x80, 0x3C, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3C, 0x78, 0x3C, 0x7F, 0xF8, 0x1F, 0xFF, 0xF0, 0x1F, 0xF7, 0xF0, 0x0F, 0xE3, 0xE0, 0x07, 0xC0, 0x01, 0xFE, 0x07, 0xFF, 
0x80, 0x0F, 0xFF, 0xE0, 0x1F, 0xFF, 0xF0, 0x1F, 0x01, 0xF0, 0x3C, 0x78, 0x3C, 0x78, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x1C, 0x70, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x1C, 0x78, 0x1F, 0x01, 0xF0, 0x0F, 0xFF, 0xF0, 0x0F, 0xFF, 0xE0, 0x03, 0xFF, 0xC0, 0xFF, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 
0xF8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xFE, 0x07, 0xFF, 0x80, 0x0F, 0xFF, 0xC0, 0x1F, 0xFF, 0xE0, 0x1F, 0x01, 0xF0, 0x3C, 0xF0, 0x3C, 0x78, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 
0x38, 0x38, 0x38, 0x38, 0x3F, 0xF8, 0x38, 0x3F, 0xF8, 0x38, 0x1F, 0xF8, 0x70, 0x1F, 0xF8, 0x70, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 
0x38, 0x38, 0x1C, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3C, 0x38, 0x1F, 0xFF, 0xF8, 0x1F, 0xFF, 0xF8, 0x0F, 0xFF, 0xF8, 0x07, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x38, 0xFE, 0x01, 0xFF, 0x80, 0x07, 0xFF, 0xC0, 0x1F, 0xC7, 0xF0, 0x3F, 0x01, 0xF8, 0x3E, 0x78, 0x38, 0x38, 0x30, 0x08, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 
0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x78, 0x03, 0xF8, 0x1F, 0xE0, 0xFF, 0xF0, 0xFF, 0x0F, 0xE0, 0x01, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x03, 0xF8, 0x0F, 0xF0, 0x7F, 0x80, 0x03, 0xFC, 0x1F, 0xF0, 0x3F, 0x80, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x01, 0xFE, 
0x07, 0xFF, 0xC0, 0x0F, 0xFF, 0xE0, 0x1F, 0xFF, 0xF0, 0x3E, 0xF0, 0x3C, 0x78, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3C, 0x78, 0x1E, 0xF8, 0x1F, 0xFF, 0xF0, 0x0F, 0xFF, 0xE0, 0x07, 0xFF, 0xC0, 0xFF, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0xE0, 0x38, 0xE0, 0x38, 0xE0, 0x38, 0xE0, 0x38, 0xF0, 0x78, 0x7F, 0xF0, 0x7F, 0xF0, 0x3F, 0xE0, 0x0F, 0xC0, 0x3F, 0xC0, 0xFF, 0xF8, 0x01, 0xFF, 0xFC, 0x03, 0xFF, 
0xFE, 0x07, 0xC0, 0x1E, 0x07, 0x80, 0x0F, 0x3F, 0x07, 0x7F, 0x07, 0xFF, 0x07, 0xFF, 0x80, 0x0F, 0xE7, 0xC0, 0x1F, 0xC3, 0xFF, 0xFE, 0xC1, 0xFF, 0xFC, 0xC0, 0xFF, 0xF8, 0xE0, 0x1F, 0xE0, 0x80, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x38, 0x38, 0x38, 0x38, 0xF8, 0x38, 0x03, 0xFC, 0x78, 0x1F, 0xFF, 0xF8, 0x3F, 0xCF, 0xF0, 0x3F, 0x0F, 0xF0, 0x38, 0x03, 0xC0, 0x20, 0x1C, 0x07, 0xC0, 0x3C, 0x0F, 0xE0, 
0x38, 0x1F, 0xF0, 0x38, 0x1F, 0xF0, 0x38, 0x3E, 0x78, 0x38, 0x3C, 0x38, 0x38, 0x3C, 0x38, 0x38, 0x78, 0x38, 0x3C, 0x78, 0x38, 0x1F, 0xF8, 0x38, 0x1F, 0xF0, 0x38, 0x0F, 0xE0, 0x70, 0x07, 0xC0, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x07, 0xFF, 0xF8, 0x0F, 0xFF, 0xF8, 0x1F, 0xFF, 0xF8, 0x1F, 0xFF, 0xF8, 0x3C, 0x38, 0x38, 0x38, 0x38, 0x3C, 
0x1F, 0xFF, 0xF8, 0x1F, 0xFF, 0xF8, 0x0F, 0xFF, 0xF8, 0x03, 0xFF, 0xF8, 0x38, 0x03, 0xF8, 0x1F, 0xF8, 0x01, 0xFF, 0xF8, 0x0F, 0xFF, 0x80, 0x3F, 0xF8, 0x3F, 0xC0, 0x3C, 0x3F, 0x80, 0x3F, 0xF8, 0x07, 0xFF, 0xFF, 0xF0, 0x1F, 0xF8, 0x03, 0xF8, 0x38, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3E, 0x3F, 0xC0, 0x07, 0xFC, 0x1E, 0x01, 0xFE, 0x1F, 0xF0, 0x3F, 0x80, 0x3C, 0x3F, 0xFF, 0xF0, 0x3F, 0xFF, 0xF8, 0xFF, 0xF8, 0x20, 0x08, 
0x38, 0x38, 0x3E, 0x78, 0x3F, 0x81, 0xF8, 0x1F, 0xC7, 0xF8, 0x07, 0xFF, 0xE0, 0x01, 0xFF, 0xC0, 0x7F, 0x80, 0x01, 0xFF, 0x80, 0x07, 0xFF, 0xE0, 0x1F, 0xC7, 0xF0, 0x3F, 0x81, 0xF8, 0x3E, 0x78, 0x3C, 0x38, 0x30, 0x08, 0x08, 0x38, 0xF8, 0x03, 0xF8, 0x0F, 0xF0, 0x3F, 0xC0, 0x3F, 0xFF, 0x3F, 0xF8, 0x3F, 0xF8, 0x3F, 0xFF, 0x3F, 0xC0, 0x0F, 0xF0, 0x03, 0xF8, 0xF8, 0x38, 0x08, 0x38, 0x38, 0x3C, 0x38, 0x3F, 0x38, 0x3F, 0xC0, 0x38, 0x3F, 
0xE0, 0x38, 0x39, 0xF8, 0x38, 0x38, 0xFE, 0x38, 0x38, 0x3F, 0x38, 0x38, 0x0F, 0xF8, 0x38, 0x07, 0xF8, 0x38, 0x01, 0xF8, 0x38, 0xF8, 0x38, 0x38, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x07, 0xE0, 0x07, 0xE0, 0x07, 0xE0, 0x07, 0x04, 0x3C, 0xFC, 0x03, 0xFC, 0x1F, 0xE0, 0x7F, 0x80, 0x03, 0xFE, 0x0F, 0xF0, 0x3F, 0xC0, 0xFE, 0xF8, 0xE0, 0xE0, 0x07, 0xE0, 0x07, 0xE0, 0x07, 0xE0, 0x07, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0x0E, 0x0F, 0x80, 0x0F, 0xC0, 0x03, 0xF0, 0xF8, 0x38, 0xF8, 0x03, 0xF0, 0x0F, 0xC0, 0x0F, 0x80, 0x0E, 0x0C, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x04, 0x0C, 0x1C, 0x3C, 0x3C, 0x38, 0x30, 0x20, 0x0F, 0x1F, 0x8E, 0x3F, 0xC6, 0x3F, 0xE7, 0x39, 0xE7, 0x38, 0xE7, 0x38, 0xE7, 0x18, 0xE7, 0x1C, 0xE7, 0x3F, 0xFF, 
0x3F, 0xFE, 0x3F, 0xFE, 0x3F, 0xFC, 0x1F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x38, 0x1E, 0x38, 0x0E, 0x38, 0x07, 0x38, 0x07, 0x3E, 0x0F, 0x1F, 0xFF, 0x1F, 0xFE, 0x0F, 0xFC, 0x03, 0xF8, 0x03, 0xF0, 0x0F, 0xF8, 0x1F, 0xFC, 0x1F, 0xFE, 0x3E, 0x1E, 0x3C, 0x0F, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x1C, 0x0E, 0x07, 0xF0, 0x0F, 0xFC, 0x1F, 0xFE, 0x3F, 0xFE, 0x3C, 0x1F, 0x38, 0x07, 
0x38, 0x07, 0x1C, 0x07, 0x1E, 0x07, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x03, 0xF0, 0x0F, 0xF8, 0x1F, 0xFC, 0x1F, 0xFE, 0x3C, 0xEF, 0x3C, 0xE7, 0x38, 0xE7, 0x38, 0xE7, 0x38, 0xE7, 0x38, 0xEF, 0x38, 0xFE, 0x18, 0xFE, 0x1C, 0xFC, 0xF8, 0x0E, 0x0E, 0x0E, 0x0E, 0x3F, 0xFF, 0xE0, 0x3F, 0xFF, 0xF0, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xFC, 0x0E, 0x3C, 0x0E, 0x1C, 0x0E, 0x1C, 0x0E, 0x1C, 0x0E, 0x1C, 0x1C, 
0x38, 0x7E, 0xE7, 0x80, 0x7F, 0xFF, 0xE0, 0xFF, 0xFF, 0xE0, 0xE3, 0xFF, 0xF0, 0xE3, 0x9C, 0x70, 0xE3, 0x9C, 0x70, 0xE3, 0x9C, 0x70, 0xE3, 0x9F, 0xF0, 0xF3, 0x8F, 0xF0, 0x7F, 0x8F, 0xF0, 0x7F, 0x87, 0xF0, 0x3F, 0x70, 0x1E, 0x70, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x1E, 0x0E, 0x07, 0x07, 0x07, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFE, 0x3F, 0xFC, 0x38, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 
0x18, 0x3F, 0xFF, 0x3C, 0x3F, 0xFF, 0x3C, 0x3F, 0xFF, 0x3C, 0x3F, 0xFF, 0x18, 0x38, 0x38, 0x38, 0x70, 0x03, 0x80, 0xE0, 0x03, 0x80, 0xE0, 0x03, 0x80, 0xE0, 0x03, 0x80, 0xE0, 0x03, 0x80, 0xE0, 0x03, 0x80, 0xF0, 0x03, 0x8C, 0x7F, 0xFF, 0x9E, 0x7F, 0xFF, 0x9E, 0x3F, 0xFF, 0x9E, 0x1F, 0xFF, 0x8C, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0xE0, 0x01, 0xF0, 0x03, 0xF8, 0x0F, 0xFC, 0x1F, 0xBE, 0x3F, 0x1F, 
0x3C, 0x07, 0x38, 0x03, 0x20, 0x01, 0x38, 0x1C, 0x38, 0x1C, 0x38, 0x1C, 0x38, 0x1C, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x38, 0x38, 0x38, 0x38, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x0E, 0x07, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFC, 0x0E, 0x07, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFC, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x1E, 0x0E, 0x07, 0x07, 0x07, 0x3F, 
0xFF, 0x3F, 0xFF, 0x3F, 0xFE, 0x3F, 0xFC, 0x03, 0xF0, 0x0F, 0xFC, 0x1F, 0xFE, 0x1F, 0xFE, 0x3C, 0x1F, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x3E, 0x0F, 0x1F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFC, 0x03, 0xF0, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xF0, 0x03, 0x81, 0xE0, 0x03, 0x80, 0xE0, 0x03, 0x80, 0x70, 0x03, 0x80, 0x70, 0x03, 0xE0, 0xF0, 0x01, 0xFF, 0xF0, 0x01, 0xFF, 0xE0, 0xFF, 0xC0, 0x3F, 0x80, 
0x7F, 0xFF, 0xC0, 0x01, 0xFF, 0xE0, 0x03, 0xFF, 0xE0, 0x03, 0xC1, 0xF0, 0x03, 0x80, 0x70, 0x03, 0x80, 0x70, 0x01, 0xC0, 0x70, 0x01, 0xE0, 0x70, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3C, 0x0E, 0x07, 0x07, 0x07, 0x1F, 0x1F, 0x1E, 0x1C, 0x1C, 0x3C, 0x3C, 0x7E, 0x38, 0x7E, 0x38, 0xFF, 0x38, 0xE7, 0x38, 0xE7, 0x39, 0xE7, 0x39, 0xC7, 0x3F, 0xC7, 0x1F, 
0xC7, 0x1F, 0x8E, 0x0F, 0x07, 0x07, 0x07, 0x07, 0x0F, 0xFF, 0xF0, 0x1F, 0xFF, 0xF0, 0x3F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF8, 0x3C, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x0F, 0xFF, 0x1F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x38, 0x38, 0x38, 0x1C, 0x1E, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x3F, 0xFF, 0x03, 0x1F, 0x7F, 0x01, 0xFF, 0x0F, 0xF8, 0x3F, 0xC0, 0x3F, 0x38, 0x3E, 0x3F, 0xC0, 0x0F, 0xF8, 0x01, 0xFE, 0x7F, 0x1F, 0x03, 
0x3F, 0x07, 0xFF, 0x3F, 0xFF, 0x3F, 0xE0, 0x38, 0x3F, 0x80, 0x07, 0xF0, 0x70, 0x07, 0xF0, 0x3F, 0xC0, 0x3C, 0x3F, 0xC0, 0x3F, 0xFF, 0x07, 0xFF, 0x3F, 0x20, 0x01, 0x38, 0x03, 0x3C, 0x0F, 0x3E, 0x1F, 0x0F, 0xBE, 0x07, 0xFC, 0x01, 0xF0, 0x03, 0xF0, 0x0F, 0xF8, 0x3F, 0x3E, 0x3E, 0x1F, 0x38, 0x07, 0x30, 0x03, 0x20, 0x01, 0xE0, 0x30, 0xE0, 0x01, 0xF0, 0xE0, 0x07, 0xF0, 0xE0, 0x1F, 0xF0, 0xF0, 0xFF, 0x80, 0x7F, 0xFC, 0x3F, 0xF0, 0x1F, 
0xC0, 0x07, 0xF0, 0x01, 0xFC, 0x7F, 0x80, 0x1F, 0xE0, 0x07, 0xF0, 0xF0, 0x30, 0x30, 0x07, 0x3C, 0x07, 0x3E, 0x07, 0x3F, 0x07, 0x3F, 0x87, 0x3B, 0xE7, 0x39, 0xF7, 0x38, 0xFF, 0x38, 0x3F, 0x38, 0x1F, 0x38, 0x0F, 0x38, 0x07, 0x1C, 0x1C, 0x1C, 0x3E, 0x1F, 0xFF, 0xF8, 0x3F, 0xF7, 0xFC, 0x7F, 0xF7, 0xFE, 0xFF, 0xE3, 0xFF, 0xF0, 0x0F, 0xE0, 0x07, 0xE0, 0x07, 0xE0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xE0, 0x07, 0xE0, 0x07, 0xE0, 0x07, 0xF0, 0x0F, 0xFF, 0xE3, 0xFF, 0x7F, 0xF7, 0xFE, 0x3F, 0xF7, 0xFC, 0x1F, 0xFF, 0xF8, 0x3E, 0x1C, 0x1C, 0x1C, 0x70, 0x7C, 0x7E, 0x0E, 0x0E, 0x1E, 0x3C, 0x78, 0xF0, 0xE0, 0xE0, 0xFC, 0x7C, 0x1C
};  


/**
 * TERMS OF USE: MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
